<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="css/studio.css">
    <?php require_once("inc/header.php"); ?>
</head>
<style>
    /* preloader */
    body, html {
        scroll-behavior: smooth;
    }
    /* preloader */
    #preloader {
        background-color: #b6144f;
        width:100%;
        height:100vh;
        position: fixed;
        left:0;
        top:0;
        z-index: 99;
        display:flex;
        align-items:center;
        justify-content:center;
    }
    .ne-yapariz-carts {
        display:flex;
        justify-content:center;
        width:100%;
        
    }
    .ne-yapariz-carts ul {
        display:flex
    }
    .ne-yapariz-carts ul li {
        list-style:none
    }
    .ne-yapariz-carts ul li a {
        font-size:22px;
        width:250px;
        background:#b0134c;
        color:#fff;
        font-weight:bold;
        display:flex;
        justify-content:center;
        height:300px;
        align-items:center;
        margin-right:10px;
        text-align:center;
        padding:20px;
        box-sizing:border-box;
        border-radius:30px;
        position:relative;
       
    }
    .ne-yapariz-carts ul li a span {
        text-shadow:0 0 10px #d2d2d2
    }
   
    .ne-yapariz-carts ul li a img {
        position:absolute;
        width:100%;
        height:100%;
        object-fit:cover;
        opacity:0.2;
        border-radius:30px
    }
    .ne-yapariz-baslik {
        font-size:28px;
        text-align:center;
        margin-top:150px;
        background:#fafafa;
        padding:20px 0;
        font-weight:700;
        font-family: 'Sarabun', sans-serif;
    }

    /* */
    .bodyContainer {
        padding-right:40px
    }
    .ne-yapariz-list {
        margin-top:30px
    }
    .ne-yapariz-list ul li {
        list-style:none;
        margin:150px 0;
    }
    .ne-yapariz-list ul li a {
        padding:10px
    }
    .ne-yapariz-list ul li h2 {
        text-align:center;
        position:relative;
        font-size:30px;
        display:flex;
        align-items:center;
        justify-content:center
    }
    .ne-yapariz-list ul li h2:before {
        content:"";
        width:20%;
        height:2px;
        position:absolute;
        left:0;
        background:#a4a4a4;
    }
    .ne-yapariz-list ul li h2:after {
        content:"";
        width:20%;
        height:2px;
        position:absolute;
        right:0;
        background:#a4a4a4;
    }
    .ne-yapariz-list-cont {
        display:flex;
        justify-content:space-between;
        max-width:1100px;
        margin:0 auto
    }
    .ne-yapariz-list-cont img {
        width:400px;
        height:300px;
        object-fit:cover;
        box-shadow:0 0 10px #333
    }
    .ne-yapariz-list-p p{
        font-size:18px;
        color:#212529;
        line-height:24px;
        margin-right:30px
    }
    @media only screen and (max-width: 600px) { 
        .ne-yapariz-carts ul {
            flex-direction:column!important;
        }
        .ne-yapariz-carts ul li {
            margin-bottom:20px;
        }
        .ne-yapariz-list-cont {
            flex-direction:column-reverse
        }
        .ne-yapariz-list-cont img {
            width:100%;
            height:auto;
            margin-bottom:20px
        }
        .ne-yapariz-list ul li h2:before,  .ne-yapariz-list ul li h2:after  {
            display:none
        }
        .ne-yapariz-list ul li {
            border-bottom:1px #ddd solid;
            margin:0;
            padding:30px 0
        }
    }
    .metin {
        max-width:1100px;
        margin:0 auto
    }
    .metin h2 {
        font-size:24px;
        font-family:'Martsel Sans', sans-serif;
        margin-bottom:10px;
        margin-top:30px
    }
    .metin p {
        font-size:18px;
        line-height:22px;
        font-family:'Martsel Sans', sans-serif;
        padding:10px
    }
    .metin-videolar {
        margin:20px 0;
        padding:20px;
    }
    .metin-videolar ul{
        display:flex;
        justify-content:space-between
    }
    .metin-videolar ul li {
        list-style:none;
        border-radius:10px
    }
    .metin-videolar ul li iframe {
        border-radius:10px
    }
    .metin-videolar img {
        width:100%;
        margin:20px 0 
    }

    @media only screen and (max-width: 600px) { 
        .ne-yapariz-video iframe{
            width:100% !important
        }
        .metin img {
            width:100% !important
        }
        .metin {
            margin:20px
        }
        .metin p {
            width:100%
        }
        .ne-yapariz-list-p p {
            width:100%;
        }
        .metin-videolar ul{
            flex-direction:column
        }
        .metin-videolar ul li {
            margin-bottom:15px
        }
        .metin {
            padding:20px
        }
    }
    
</style>
<script src="js/jquery.js"></script>
<script>
    $(function(){
        $(window).ready(function(){
            $("#preloader").delay(1000).fadeOut("slow");
        });
    });
</script>
<body>
    
    <div id="preloader">
        <img src="images/logo-pre-home.gif?vdvdddccd" alt="">
    </div>
    <!-- Nav Menu -->
    <div class="navMenuButton navMenuClose">
        <span></span>
        <span></span>
        <span></span>
    </div>
    <div class="navMenu" style="display:none">
        <div class="navMenuContainer">
        <ul>
                <li><a href="<?php echo $link; ?>">ANASAYFA</a></li>
                <li><a href="https://kameraekipman.com/">EKİPMANLAR</a></li>
                <li>
                    <a style="cursor:pointer" class="mobil-dropdown-click">NE YAPARIZ?</a>
                    <ul class="dropdown-mobil">
                    <li>
                                    <a href="tanitim-filmleri.php">Tanıtım Filmleri</a>
                                </li>
                                <li>
                                    <a href="reklam-filmleri.php">Reklam Filmeri</a>
                                </li>
                                <li>
                                    <a href="produksiyon-hizmetleri.php">Prodüksiyon Hizmetleri</a>
                                </li>
                                <li>
                                    <a href="belgesel-calismalari.php">Belgesel Çalışmaları</a>
                                </li>
                                <li>
                                    <a href="sosyal-medya-videolari.php">Sosyal Medya Videoları</a>
                                </li>
                            </ul>
                </li>
                <li><a href="hakkimizda.php">HAKKIMIZDA</a></li>
                <li><a href="iletisim.php">İLETİŞİM</a></li>
            </ul>
            <p>
            <?php
                    echo $adres;
                ?>
            </p>
            <div class="navMenuContainerSocial">
                <a href="<?php echo $twitter; ?>">
                    <img src="images/twitter.svg" alt="">
                </a>
                <a href="<?php echo $facebook; ?>">
                    <img src="images/facebook.svg" alt="">
                </a>
                <a href="<?php echo $instagram; ?>">
                    <img src="images/instagram.svg" alt="">
                </a>
            </div>
            <div class="navMenuContainerLogo">
                <img src="images/logo-black.png?vv" alt="">
            </div>
        </div>
        
    </div>
    <div class="navLogo2">
        <a href="index.php">
            <img src="images/logo-black.png?vv" alt="Logo">
        </a>
    </div>
    <div class="bodyContainer">
       
       <div class="ne-yapariz-list">
            <ul>
                <li id="ne-yapariz">
                    <h2 style="margin-bottom:50px">Prodüksiyon Hizmetleri</h2>
                    <div class="ne-yapariz-list-cont">
                        <div class="ne-yapariz-list-p">
                            <p>Prodüksiyon; reklam, filmleri, müzik klipleri, diziler, belgeseller ve diğer benzeri tüm içerik formatları için üretim sürecini ifade eden genel bir kavram olarak kullanılır. Genel bir tanımlama yapmak gerekirse prodüksiyon nedir sorusuna; görsel ve işitsel materyallerin üretim, tasarım, yaratım ve optimizasyon süreçleri şeklinde yanıt verilebilir. Bugün pazarlama açısından büyük önem arz eden tanıtım filmi ya da reklam filmi gibi içerikler de birer prodüksiyon hizmetidir.</p>
                            <p>Prodüksiyon hizmetleri ile sektörün fark yaratan işletmelerinden bir tanesi olmaya hazır mısınız? Gelin hep birlikte post prodüksiyon nedir ve prodüksiyon süreci sizi nasıl daha önemli noktalara taşır daha yakından inceleyelim!</p>
                            <p>Prodüksiyon hizmetleri dahilinde; reklam filmi prodüksiyonu, belgesel prodüksiyon, kamera çekim ve video düzenleme (editleme) gibi farklı yaklaşımlar öne çıkar. Her yaklaşımın kendine has özellikleri olduğunu vurgularken bu yaklaşımların profesyonel ekiplerce sürdürülmesi gerekliliğinden de bahsetmek gerekir.</p>
                            <p>Bu bilgiler ışığında prodüksiyon işlemleri için profesyonel yaklaşım, uzun süreli deneyim ve şüphesiz ki teknolojik altyapı gerektiğini söylemek doğru olacaktır.</p>
                        </div>
                        <div class="ne-yapariz-video">
                        <iframe width="450" height="300" align="middle" allow="autoplay; fullscreen" allowfullscreen="" frameborder="0" height="300" scrolling="no" src="https://player.vimeo.com/video/417140352?title=0&amp;byline=0&amp;portrait=0" width="100%"></iframe>
                        </div>
                    </div>
                </li>
            </ul>
       </div>
        <div class="metin">
            <h2 style="font-size:28px">Prodüksiyon Hizmetleri Dahilinde Öne Çıkan Başlıklar</h2>
            <p>
            Yukarıda da bahsettiğimiz gibi prodüksiyon hizmetleri kapsamında farklı alt başlıkların mevcut olduğu söylenebilir. Her bir hizmet, farklı ihtiyaca yönelik çözümlere odaklandığından farklı süreçler gerektirir. Video üretimi, reklam filmi prodüksiyonu gibi prodüksiyon süreçleri dahilinde öne çıkan başlıklar şu şekildedir:
            </p>
            <h2>Çok Kameralı Reji Hizmetleri</h2>
            <p>Çok kameralı reji hizmetleri dahilinde yapımcı, reji sorumlusu, uygulayıcı yapımcı, yapım asistanları gibi profesyoneller yer alır. Çekimi yapılacak olan projeye göre farklı açılardan görüntüleme ihtiyacının olduğu durumlarda kullanılan çok kameralı prodüksiyon, kapsamlı prodüksiyon projeleri için ideal çözümler arasında yer alır.</p>
            <h2>Müzik Video & Klip Prodüksiyon Hizmetleri</h2>
            <p>Modern eğlence ekonomisinde en önemli prodüksiyon ürünleri arasında yer alan müzik klipleri, detaylı bir prodüksiyon süreci ile tasarlanırlar. Müzik video ve klip prodüksiyonu kapsamında; müziğinizi görsel bir şölenle bir araya getirebilir ve dinleyicilerinize farklı kanallar üzerinden ulaşabilirsiniz. Zira başarılı bir müzik eserinin başarılı bir klip çalışması ile piyasaya sürülmesi başarının katlanmasına olanak sağlar</p>
            <div class="metin-videolar">
                <ul>
                    <li>
                        <iframe width="100%" height="100%" src="https://www.youtube.com/embed/Z5JEtR7JFro" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </li>
                    <li>
                        <iframe width="100%" height="100%" src="https://www.youtube.com/embed/MDdEs3CbT5s" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </li>
                    <li>
                    <iframe src="https://player.vimeo.com/video/740494551"  frameborder="0" title="Quandoo İstanbul" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
                    </li>
                </ul>
            </div>
            <h2>Etkinlik Prodüksiyonu</h2>
            <p>Etkinlik prodüksiyonu,ya da event prodüksiyonu outdoor ya da indoor olmak üzere lokasyon bazlı etkinliklerinin organizasyon sürecini kapsayan bir prodüksiyon hizmeti olarak öne çıkar. Kutlama, seminer, şirket toplantıları, konser, ürün lansmanı ve festival gibi etkinliklerde arka plandaki tüm sürecin organize edilmesi; detaylı bir etkinlik prodüksiyon stratejisi ile mümkündür. Bu da elbette daha önce etkinlik prodüksiyonu alanında uzmanlaşmış kaliteli bir ekiple gerçekleşecektir.</p>
            <h2>Reklam Filmi Prodüksiyonu</h2>
            <p>Şirketlerin ve organizasyonların en önemli pazarlama araçlarından olan reklam filmleri; ürün ve şirket tanıtımı, marka farkındalığı arttırma gibi amaçlar için kullanılır. Medya stratejisi ve pazarlama planı gibi diğer bileşenlerle entegre yürütülen reklam filmi prodüksiyonu için farklı prodüksiyonu ekipleri ve profesyonellerin bir arada çalışması gerekir.</p>
            <h2>TV Yapımı Prodüksiyonları</h2>
            <p>TV yapım prodüksiyonları, televizyon içeriği üretimine odaklanan bir hizmet olarak öne çıkar. Dizi, televizyon şovu gibi TV odaklı içerikler için gerekli olan kamera, yönetmen ve çekim ekibinin temini, TV yapım prodüksiyonu dahilinde değerlendirilebilir.</p>
            <h2>Post Prodüksiyon Hizmetleri</h2>
            <p>Terminoloji olarak post prodüksiyon, çekimi yapılmış olan bir videonun; ses, ışık, görüntü, kurgu gibi değişkenler dahilinde optimize edilmesi olarak tanımlanır. Video düzenleme işlemi ile benzer olsa da post prodüksiyon hizmeti daha kapsamlı ve çok yönlü bir hizmettir. Grafiker, video tasarımcı, ses tasarım uzmanı ve sanat yönetmeni gibi profesyonellerin görev aldıkları post prodüksiyon sürecinde After Effect, Edius, Premiere gibi video programları kullanılır. Ekip becerisi kadar bu programların çeşitlendirilmesi post prodüksiyonun başarısına doğrudan etki eder.</p>
            <h2 style="font-size:28px">Prodüksiyon Süreci Nasıl İşler?</h2>
            <p>Prodüksiyon süreci için farklı ekiplerin, profesyonellerin, altyapı ve ekipmanların bir arada kullanılması gerekir. Yapılacak olan projenin niteliğine göre çeşitli ekipmanlar ve görüntü tasarımı, ses tasarımı gibi farklı disiplinlerden uzmanlarla çalışılabilir. Genel olarak bahsetmek gerekirse prodüksiyonu yapılacak olan projeye öncelikli olarak bir proje yöneticisi atanır. Atanacak olan proje yöneticisi, proje dahilindeki ekipman ve ekip ihtiyaçlarını tespit ederek raporlar. Gerekli olan ihtiyaçlar temin edilerek proje için bir takvim planı oluşturulur. Süreç dahilinde proje ile alakalı tüm bilgiler ortak bir alanda toplanarak projede çalışan tüm ekiplerin erişimine sunulur.</p>
            <div class="ne-yapariz-ul">
                <ul>
                    <li>
                        <p>15 yıllık deneyimli, alanında uzman bir ekiple çalışarak kaliteli bir prodüksiyon hizmeti alın.</p>
                    </li>
                    <li>
                        <p>İletişim stratejisini video içerikle destekleyerek rakipleriniz arasında fark yaratın.</p>
                    </li>
                    <li>
                        <p>Prodüksiyon hizmetleri ile ilgili tüm ihtiyaçlarınızı <a href="https://sinefikir.com/">Sinefikir</a> gücüyle tek bir ajanstan alın.</p>
                    </li>
                    <li>
                        <p>Son teknoloji ekipmanların yüksek görsellik değeri taşıyan çekim kalitesiyle tanışın.</p>
                    </li>
                </ul>
            </div>
            
            <p>Tüm bunların yanı sıra prodüksiyon proje üretimi için yaratıcı senaryo desteği gibi ihtiyaçlar mevcutsa, bu ihtiyaçlarla alakalı süreçler planlanır. Süreçle alakalı detaylar sonrasında finalize edilip profesyonel ekip tarafından çekimle alakalı işlemler başlatılır. Yüksek çözünürlüklü prodüksiyon teknolojileri ve gelişmiş görüntü altyapısı kullanılarak projeniz 360 derece kontrol altına alınır. <a href="https://sinefikir.com/">Sinefikir</a> olarak süreç kapsamında kendi markamız olan Kamera Fabrikası ile çalışarak üst düzey bir hizmet deneyimi vaat eder.</p>
            <p><a href="https://sinefikir.com/">Sinefikir</a> ekibi ve yine kendi markamız olan Kamera Fabrikası son teknoloji ekipman gücüyle çekiminiz yapılır. Entegre görüntüleme sistemleri ile görüntü zenginliği sağlanır. Grafik ve kurgu ekibimiz tarafından motion ve post production hizmetleriyle finalize edilen video size sunulur.</p>
            <p><a href="https://sinefikir.com/">Sinefikir</a> olarak; video prodüksiyon hizmetlerimiz, alanında uzman teknik kadromuz, kendi markamız olan Kamera Fabrikası ekipman gücümüz, hedefe ulaştıran içerik üretimi ekibimiz ve güleryüzlü hizmet anlayışımızla sizi bir kahve molası için ofisimize bekliyoruz.</p>
            <p>Bizlere +90 530 215 56 26 no'lu telefondan ulaşarak teklif ve destek alabilirsiniz.</p>
            <div style="max-width:500px; margin:20px auto">
                <img src="https://www.piktorayapim.com/uploads/produksiyon-hizmetleri.png" alt="" style="width:100%">
            </div>
            
            
        </div>
    </div>

<?php require_once("inc/footer.php") ?>