(function ($) {
  "use strict";

  $(function () {
    //Data Background Set
    $('[data-background]').each(function () {
      $(this).css('background-image', 'url(' + $(this).attr('data-background') + ')');
    }); //ScrollTop 

    $(".scrolltop-btn").on("click", function () {
      $("body,html").animate({
        scrollTop: 0
      });
    }); //Mobile Menu 

    $(".mobile-menu-toggle").on("click", function () {
      $(".body-overlay").addClass('overlay-on');
      $(".mobile-menu").addClass("active");
      return false;
    });
    $(".close-menu").on("click", function () {
      $(".mobile-menu").removeClass("active");
      $(".body-overlay").removeClass("overlay-on");
    });
    $(".body-overlay").on("click", function () {
      $(".mobile-menu").removeClass("active");
      $(this).removeClass("overlay-on");
    });
    $(".mobile-menu ul li.has-submenu a").each(function () {
      $(this).on("click", function () {
        $(this).siblings('ul').slideToggle();
        $(this).toggleClass("icon-rotate");
      });
    }); //Canvus Menu 

    $(".ofcanvus-btn").on("click", function () {
      $(".ofcanvus-menu").addClass("active");
      return false;
    });
    $(".close-canvus").on("click", function () {
      $(".ofcanvus-menu").removeClass("active");
      return false;
    }); // Hide ofcanvus when click outside it.

    $(document).on("mouseup", function (e) {
      const ofcanvusMenu = $(".ofcanvus-menu");

      if (!ofcanvusMenu.is(e.target) && ofcanvusMenu.has(e.target).length === 0) {
        ofcanvusMenu.removeClass("active");
      }
    }); //ThemeSwitcher

    var getLocalValue = localStorage.getItem("theme-mood");
    var themeSwitchBtn = document.getElementById("theme-switch");

    if (getLocalValue) {
      document.body.classList.add(getLocalValue);
    }

    // themeSwitchBtn.addEventListener("click", function () {
    //   var bodyElement = document.body;
    //   bodyElement.classList.toggle("theme-dark");

    //   if (bodyElement.classList.contains("theme-dark")) {
    //     localStorage.setItem("theme-mood", "theme-dark");
    //   } else {
    //     localStorage.setItem("theme-mood", '');
    //   }
    // }); //Pricing Table
    localStorage.setItem("theme-mood", "theme-dark");
    

    $(".switch-input").on("change", function () {
      if (this.checked) {
        $(".yearly-price").css({
          display: 'block'
        });
        $(".monthly-price").css({
          display: 'none'
        });
      } else {
        $(".yearly-price").css({
          display: 'none'
        });
        $(".monthly-price").css({
          display: 'block'
        });
      }
    });
    $(".expand-btn").each(function () {
      $(this).on("click", function () {
        $(this).siblings(".feature-list").toggleClass("expand-list");
        $(this).toggleClass("active");
      });
    }); //Feedback Slider 

    const swiper = new Swiper('.feedback-slider', {
      slidesPerView: 3,
      speed: 700,
      spaceBetween: 30,
      slidesPerGroup: 2,
      loop: true,
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        1200: {
          slidesPerView: 3
        }
      }
    });
    const blogSlider = new Swiper('.hm2-blog-slider', {
      slidesPerView: 3,
      spaceBetween: 30,
      loop: true,
      pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        1200: {
          slidesPerView: 3
        }
      }
    });
    const brandSlider = new Swiper(".brand-slider", {
      slidesPerView: 5,
      spaceBetween: 30,
      loop: true,
      autoplay: {
        delay: 3000
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        400: {
          slidesPerView: 2,
          spaceBetween: 20
        },
        768: {
          slidesPerView: 3
        },
        992: {
          slidesPerView: 4,
          spaceBetween: 25
        },
        1200: {
          slidesPerView: 5,
          spaceBetween: 25
        }
      }
    });
    const productSlider = new Swiper(".gm-product-slider", {
      slidesPerView: 4,
      spaceBetween: 30,
      loop: true,
      autoplay: {
        delay: 3000
      },
      pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        992: {
          slidesPerView: 3
        },
        1400: {
          slidesPerView: 4,
          spaceBetween: 25
        }
      }
    });
    const dmFeedbackSlider = new Swiper(".dm-feedback-slider", {
      slidesPerView: 3,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        992: {
          slidesPerView: 3
        }
      }
    });
    const vps_scripts_slider = new Swiper(".vps-scripts-slider", {
      slidesPerView: 6,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      navigation: {
        nextEl: '.swiper-next',
        prevEl: '.swiper-prev'
      },
      autoplay: {
        delay: 5000
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        400: {
          slidesPerView: 2
        },
        768: {
          slidesPerView: 3
        },
        992: {
          slidesPerView: 4
        },
        1200: {
          slidesPerView: 5
        },
        1400: {
          slidesPerView: 6
        }
      }
    }); //HM2 Feedback Slider 

    const hm2_feedback_slider = new Swiper(".hm2-feedback-slider", {
      slidesPerView: 1,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      }
    }); //Game Hosting Feedback Slider

    const gh_feedback_slider = new Swiper(".gh-feedback-slider", {
      slidesPerView: 3,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      },
      breakpoints: {
        320: {
          slidesPerView: 1
        },
        992: {
          slidesPerView: 2
        },
        1200: {
          slidesPerView: 3
        }
      }
    }); //Game Hosting Feedback Slider

    const h4_feedback_slider = new Swiper(".h4-feedback-slider", {
      slidesPerView: 3,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        1200: {
          slidesPerView: 3
        }
      }
    }); //home4 apps slider 

    const h4AppsSlider = new Swiper(".h4-apps-slider", {
      slidesPerView: 4,
      spaceBetween: 24,
      loop: true,
      autoplay: {
        delay: 3000
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        375: {
          slidesPerView: 2,
          spaceBetween: 20
        },
        768: {
          slidesPerView: 3
        },
        992: {
          slidesPerView: 4,
          spaceBetween: 25
        }
      }
    });
    const h5FeedbackSlider = new Swiper(".h5-feedback-slider", {
      slidesPerView: 3,
      spaceBetween: 24,
      loop: true,
      autoplay: {
        delay: 3000
      },
      navigation: {
        nextEl: '.swiper-next',
        prevEl: '.swiper-prev'
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        1200: {
          slidesPerView: 2
        },
        1400: {
          slidesPerView: 3
        }
      }
    });
    const pricingPlanSlider = new Swiper(".pricing-plan-slider", {
      slidesPerView: 4,
      spaceBetween: 24,
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      },
      pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2
        },
        992: {
          slidesPerView: 3
        },
        1400: {
          slidesPerView: 4
        }
      }
    });
    const emPricingSlider = new Swiper(".em-pricing-slider", {
      loop: true,
      speed: 1500,
      autoplay: {
        delay: 5000
      },
      pagination: {
        el: '.swiper-pagination',
        type: 'bullets',
        clickable: true
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 2,
          centeredSlides: false,
          spaceBetween: 24
        },
        992: {
          slidesPerView: 3,
          centeredSlides: true,
          spaceBetween: -25
        }
      }
    });
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl);
    }); //Accordion 

    $(".hm2-accordion .accordion-header a").each(function () {
      $(this).on("click", function () {
        $(this).parents(".accordion").find(".show").parents(".acoridion-item").addClass("active");
      });
    });
  }); //video popup

  $('.vps-video-popup').magnificPopup({
    type: 'iframe'
  }); //counterup

  $('.counter').counterUp({
    delay: 10,
    time: 1000
  }); //countdown timer

  $(".countdown-timer").each(function () {
    var $data_date = $(this).data('date');
    $(this).countdown({
      date: $data_date
    });
  });
  $(window).on("scroll", function () {
    var offsetTop = $(window).scrollTop();

    if (offsetTop > 150) {
      $(".scrolltop-btn").fadeIn();
    } else {
      $(".scrolltop-btn").fadeOut();
    }

    var scrollBarPosition = $(window).scrollTop();

    if (scrollBarPosition > 80) {
      $("header").addClass("sticky-header");
    } else {
      $("header").removeClass("sticky-header");
    }
  }); //Sticky Header 

  jQuery(window).on('load', function () {
    var feedBack = document.querySelectorAll(".feedback-wrapper");

    if (feedBack.length > 0) {
      var elem = document.querySelector('.feedback-massonry');
      var msnry = new Masonry(elem, {
        itemSelector: '.col-lg-4',
        columnWidth: 1
      });
    }

    $(".loader-wrap").fadeOut(); //Price range slider

    $(".range-slider").slider({
      min: 1,
      max: 6,
      value: 2
    });
    var rangeInput = $("#vps_range_slider input");
    var checkValue = rangeInput.val(); //vps 1 value

    if (checkValue <= 1) {
      $(".vps_value").hide();
      $(".vps_1_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_1").addClass("active");
    } else if (checkValue <= 2) {
      $(".vps_value").hide();
      $(".vps_2_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_2").addClass("active");
    } else if (checkValue <= 3) {
      $(".vps_value").hide();
      $(".vps_3_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_3").addClass("active");
    } else if (checkValue <= 4) {
      $(".vps_value").hide();
      $(".vps_4_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_4").addClass("active");
    } else if (checkValue <= 5) {
      $(".vps_value").hide();
      $(".vps_5_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_5").addClass("active");
    } else if (checkValue <= 6) {
      $(".vps_value").hide();
      $(".vps_6_value").show();
      $(".vps_label").removeClass("active");
      $(".vps_label_6").addClass("active");
    }

    rangeInput.on("change", function () {
      checkValue = $(this).val();

      if (checkValue <= 1) {
        $(".vps_value").hide();
        $(".vps_1_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_1").addClass("active");
      } else if (checkValue <= 2) {
        $(".vps_value").hide();
        $(".vps_2_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_2").addClass("active");
      } else if (checkValue <= 3) {
        $(".vps_value").hide();
        $(".vps_3_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_3").addClass("active");
      } else if (checkValue <= 4) {
        $(".vps_value").hide();
        $(".vps_4_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_4").addClass("active");
      } else if (checkValue <= 5) {
        $(".vps_value").hide();
        $(".vps_5_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_5").addClass("active");
      } else if (checkValue <= 6) {
        $(".vps_value").hide();
        $(".vps_6_value").show();
        $(".vps_label").removeClass("active");
        $(".vps_label_6").addClass("active");
      }
    });
    var rangeTooltip = $("#vps_range_slider .tooltip");

    if (rangeTooltip.length > 0) {
      var tooltipOffset = rangeTooltip.attr('style').match(/\d+/g);
      var labelPosition = tooltipOffset[0];
      $(".price-slider-wrapper .vps_labels span.active").css({
        marginLeft: tooltipOffset[0] - 2 + '%'
      });
      rangeInput.on("change", function () {
        var tooltipOffset = rangeTooltip.attr('style').match(/\d+/g);
        $(".price-slider-wrapper .vps_labels span.active").css({
          marginLeft: tooltipOffset[0] - 2 + '%'
        });
      });
    } // init Isotope


    var $isotop_filter_items = $('.gh-filter-items').isotope({// options
    }); // filter items on button click

    $('.gh-filter-controls').on('click', 'button', function () {
      var filterValue = $(this).attr('data-filter');
      $isotop_filter_items.isotope({
        filter: filterValue
      });
    }); //replace active class 

    $(".gh-filter-controls button").each(function () {
      $(this).on("click", function () {
        $(this).parents(".gh-filter-controls").find("button.active").removeClass("active");
        $(this).addClass("active");
      });
    });
  }); // Contact form

  if ($("#contactForm").length) {
    $("#contactForm").on("submit", function (event) {
      if (event.isDefaultPrevented()) {
        // handle the invalid form...
        submitMSG(false, '#contact');
      } else {
        // everything looks good!
        event.preventDefault();
        submitContactForm();
      }
    });
  }

  function submitContactForm() {
    // Initiate Variables With Form Content
    var name = $('#contactForm input[name="name"]').val();
    var email = $('#contactForm input[name="email"]').val();
    var phone = $('#contactForm input[name="phone"]').val();
    var subject = $('#contactForm input[name="subject"]').val();
    var message = $('#contactForm textarea[name="message"]').val(); // Ajax call

    if (name && email && message) {
      $.ajax({
        type: "POST",
        url: "libs/contact-form-process.php",
        data: {
          "name": name,
          "email": email,
          "phone": phone,
          "subject": subject,
          "message": message
        },
        success: function success(text) {
          if (text == "success") {
            $("#contactForm")[0].reset();
            submitMSG(true, '#contact');
          } else {
            submitMSG(false, '#contact');
          }
        }
      });
    } else {
      submitMSG(false, '#contact');
    }
  } // Showing message


  function submitMSG(valid, parentSelector) {
    if (valid) {
      $(parentSelector + " .message-box").removeClass('d-none').addClass('d-block ');
      $(parentSelector + " .message-box div").removeClass('alert-danger').addClass('alert-success').text('Form submitted successfully');
    } else {
      $(parentSelector + " .message-box").removeClass('d-none').addClass('d-block ');
      $(parentSelector + " .message-box div").removeClass('alert-success').addClass('alert-danger').text('Found error in the form. Please check again.');
    }
  }
})(jQuery);