$(function() {

    var geoPhCodes = {"AC":{"names":{"en":"Ascension","ru":"\u041e\u0441\u0442\u0440\u043e\u0432 \u0412\u043e\u0437\u043d\u0435\u0441\u0435\u043d\u0438\u044f"},"masks":["247\\d{4}"]},"AD":{"names":{"en":"Andorra","ru":"\u0410\u043d\u0434\u043e\u0440\u0440\u0430"},"masks":["376\\d{6}"]},"AE":{"names":{"en":"United Arab Emirates","ru":"\u041e\u0431\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u043d\u044b\u0435 \u0410\u0440\u0430\u0431\u0441\u043a\u0438\u0435 \u042d\u043c\u0438\u0440\u0430\u0442\u044b"},"masks":["9715\\d{8}","971\\d{8}"]},"AF":{"names":{"en":"Afghanistan","ru":"\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d"},"masks":["93\\d{9}"]},"AG":{"names":{"en":"Antigua & Barbuda","ru":"\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430"},"masks":["1268\\d{7}"]},"AI":{"names":{"en":"Anguilla","ru":"\u0410\u043d\u0433\u0438\u043b\u044c\u044f"},"masks":["1264\\d{7}"]},"AL":{"names":{"en":"Albania","ru":"\u0410\u043b\u0431\u0430\u043d\u0438\u044f"},"masks":["355\\d{9}"]},"AM":{"names":{"en":"Armenia","ru":"\u0410\u0440\u043c\u0435\u043d\u0438\u044f"},"masks":["374\\d{8}"]},"AN":{"names":{"en":"Caribbean Netherlands","ru":"\u041a\u0430\u0440\u0438\u0431\u0441\u043a\u0438\u0435 \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b"},"masks":["599\\d{7}","599\\d{7}","5999\\d{7}"]},"AO":{"names":{"en":"Angola","ru":"\u0410\u043d\u0433\u043e\u043b\u0430"},"masks":["244\\d{9}"]},"AQ":{"names":{"en":"Australian bases in Antarctica","ru":"\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0430\u044f \u0430\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0431\u0430\u0437\u0430"},"masks":["6721\\d{5}"]},"AR":{"names":{"en":"Argentina","ru":"\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430"},"masks":["54\\d{10}"]},"AS":{"names":{"en":"American Samoa","ru":"\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u043e\u0435 \u0421\u0430\u043c\u043e\u0430"},"masks":["1684\\d{7}"]},"AT":{"names":{"en":"Austria","ru":"\u0410\u0432\u0441\u0442\u0440\u0438\u044f"},"masks":["43\\d{10}"]},"AU":{"names":{"en":"Australia","ru":"\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f"},"masks":["61\\d{9}"]},"AW":{"names":{"en":"Aruba","ru":"\u0410\u0440\u0443\u0431\u0430"},"masks":["297\\d{7}"]},"AZ":{"names":{"en":"Azerbaijan","ru":"\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d"},"masks":["994\\d{9}"]},"BA":{"names":{"en":"Bosnia and Herzegovina","ru":"\u0411\u043e\u0441\u043d\u0438\u044f \u0438 \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430"},"masks":["387\\d{7}","387\\d{6}"]},"BB":{"names":{"en":"Barbados","ru":"\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441"},"masks":["1246\\d{7}"]},"BD":{"names":{"en":"Bangladesh","ru":"\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448"},"masks":["880\\d{8}"]},"BE":{"names":{"en":"Belgium","ru":"\u0411\u0435\u043b\u044c\u0433\u0438\u044f"},"masks":["32\\d{9}"]},"BF":{"names":{"en":"Burkina Faso","ru":"\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e"},"masks":["226\\d{8}"]},"BG":{"names":{"en":"Bulgaria","ru":"\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f"},"masks":["359\\d{9}"]},"BH":{"names":{"en":"Bahrain","ru":"\u0411\u0430\u0445\u0440\u0435\u0439\u043d"},"masks":["973\\d{8}"]},"BI":{"names":{"en":"Burundi","ru":"\u0411\u0443\u0440\u0443\u043d\u0434\u0438"},"masks":["257\\d{8}"]},"BJ":{"names":{"en":"Benin","ru":"\u0411\u0435\u043d\u0438\u043d"},"masks":["229\\d{8}"]},"BM":{"names":{"en":"Bermuda","ru":"\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["1441\\d{7}"]},"BN":{"names":{"en":"Brunei Darussalam","ru":"\u0411\u0440\u0443\u043d\u0435\u0439\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c"},"masks":["673\\d{7}"]},"BO":{"names":{"en":"Bolivia","ru":"\u0411\u043e\u043b\u0438\u0432\u0438\u044f"},"masks":["591\\d{8}"]},"BR":{"names":{"en":"Brazil","ru":"\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f"},"masks":["55\\d{10}","55\\d{2}7\\d{7}","55\\d{2}9\\d{8}"]},"BS":{"names":{"en":"Bahamas","ru":"\u0411\u0430\u0433\u0430\u043c\u0441\u043a\u0438\u0435 \u041e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["1242\\d{7}"]},"BT":{"names":{"en":"Bhutan","ru":"\u0411\u0443\u0442\u0430\u043d"},"masks":["97517\\d{6}","975\\d{7}"]},"BW":{"names":{"en":"Botswana","ru":"\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430"},"masks":["267\\d{8}"]},"BY":{"names":{"en":"Belarus","ru":"\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c \u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u0438\u044f"},"masks":["375\\d{9}"]},"BZ":{"names":{"en":"Belize","ru":"\u0411\u0435\u043b\u0438\u0437"},"masks":["501\\d{7}"]},"CD":{"names":{"en":"Dem. Rep. Congo","ru":"\u0414\u0435\u043c. \u0420\u0435\u0441\u043f. \u041a\u043e\u043d\u0433\u043e \u041a\u0438\u043d\u0448\u0430\u0441\u0430"},"masks":["243\\d{9}"]},"CF":{"names":{"en":"Central African Republic","ru":"\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430"},"masks":["236\\d{8}"]},"CG":{"names":{"en":"Congo Brazzaville","ru":"\u041a\u043e\u043d\u0433\u043e \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c"},"masks":["242\\d{9}"]},"CH":{"names":{"en":"Switzerland","ru":"\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f"},"masks":["41\\d{9}"]},"CI":{"names":{"en":"Cote d\u2019Ivoire Ivory Coast","ru":"\u041a\u043e\u0442\u0434\u2019\u0418\u0432\u0443\u0430\u0440"},"masks":["225\\d{8}"]},"CK":{"names":{"en":"Cook Islands","ru":"\u041e\u0441\u0442\u0440\u043e\u0432\u0430 \u041a\u0443\u043a\u0430"},"masks":["682\\d{5}"]},"CL":{"names":{"en":"Chile","ru":"\u0427\u0438\u043b\u0438"},"masks":["56\\d{9}"]},"CM":{"names":{"en":"Cameroon","ru":"\u041a\u0430\u043c\u0435\u0440\u0443\u043d"},"masks":["237\\d{8}"]},"CN":{"names":{"en":"China PRC","ru":"\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0430\u044f \u041d.\u0420."},"masks":["86\\d{11}","86\\d{10}","86\\d{12}"]},"CO":{"names":{"en":"Colombia","ru":"\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f"},"masks":["57\\d{10}"]},"CR":{"names":{"en":"Costa Rica","ru":"\u041a\u043e\u0441\u0442\u0430\u0420\u0438\u043a\u0430"},"masks":["506\\d{8}"]},"CU":{"names":{"en":"Cuba","ru":"\u041a\u0443\u0431\u0430"},"masks":["53\\d{8}"]},"CV":{"names":{"en":"Cape Verde","ru":"\u041a\u0430\u0431\u043e\u0412\u0435\u0440\u0434\u0435"},"masks":["238\\d{7}"]},"CW":{"names":{"en":"Curacao","ru":"\u041a\u044e\u0440\u0430\u0441\u0430\u043e"},"masks":["599\\d{7}"]},"CY":{"names":{"en":"Cyprus","ru":"\u041a\u0438\u043f\u0440"},"masks":["357\\d{8}"]},"CZ":{"names":{"en":"Czech Republic","ru":"\u0427\u0435\u0445\u0438\u044f"},"masks":["420\\d{9}"]},"DE":{"names":{"en":"Germany","ru":"\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f"},"masks":["49\\d{11}","49\\d{10}","49\\d{9}","49\\d{8}","49\\d{7}","49\\d{6}"]},"DJ":{"names":{"en":"Djibouti","ru":"\u0414\u0436\u0438\u0431\u0443\u0442\u0438"},"masks":["253\\d{8}"]},"DK":{"names":{"en":"Denmark","ru":"\u0414\u0430\u043d\u0438\u044f"},"masks":["45\\d{8}"]},"DM":{"names":{"en":"Dominica","ru":"\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430"},"masks":["1767\\d{7}"]},"DO":{"names":{"en":"Dominican Republic","ru":"\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430"},"masks":["1809\\d{7}","1829\\d{7}","1849\\d{7}"]},"DZ":{"names":{"en":"Algeria","ru":"\u0410\u043b\u0436\u0438\u0440"},"masks":["213\\d{9}"]},"EC":{"names":{"en":"Ecuador ","ru":"\u042d\u043a\u0432\u0430\u0434\u043e\u0440 "},"masks":["593\\d{9}","593\\d{8}"]},"EE":{"names":{"en":"Estonia ","ru":"\u042d\u0441\u0442\u043e\u043d\u0438\u044f "},"masks":["372\\d{8}","372\\d{7}"]},"EG":{"names":{"en":"Egypt","ru":"\u0415\u0433\u0438\u043f\u0435\u0442"},"masks":["20\\d{10}"]},"ER":{"names":{"en":"Eritrea","ru":"\u042d\u0440\u0438\u0442\u0440\u0435\u044f"},"masks":["291\\d{7}"]},"ES":{"names":{"en":"Spain","ru":"\u0418\u0441\u043f\u0430\u043d\u0438\u044f"},"masks":["34\\d{9}"]},"ET":{"names":{"en":"Ethiopia","ru":"\u042d\u0444\u0438\u043e\u043f\u0438\u044f"},"masks":["251\\d{9}"]},"FI":{"names":{"en":"Finland","ru":"\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f"},"masks":["358\\d{10}"]},"FJ":{"names":{"en":"Fiji","ru":"\u0424\u0438\u0434\u0436\u0438"},"masks":["679\\d{7}"]},"FK":{"names":{"en":"Falkland Islands","ru":"\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["500\\d{5}"]},"FM":{"names":{"en":"F.S. Micronesia","ru":"\u0424.\u0428. \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0438"},"masks":["691\\d{7}"]},"FO":{"names":{"en":"Faroe Islands","ru":"\u0424\u0430\u0440\u0435\u0440\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["298\\d{6}"]},"FR":{"names":{"en":"Mayotte","ru":"\u041c\u0430\u0439\u043e\u0442\u0442\u0430"},"masks":["262\\d{9}","33\\d{9}","508\\d{6}","590\\d{9}"]},"GA":{"names":{"en":"Gabon","ru":"\u0413\u0430\u0431\u043e\u043d"},"masks":["241\\d{7}"]},"GD":{"names":{"en":"Grenada","ru":"\u0413\u0440\u0435\u043d\u0430\u0434\u0430"},"masks":["1473\\d{7}"]},"GE":{"names":{"en":"Rep. of Georgia","ru":"\u0413\u0440\u0443\u0437\u0438\u044f"},"masks":["995\\d{9}"]},"GF":{"names":{"en":"Guiana French","ru":"\u0424\u0440. \u0413\u0432\u0438\u0430\u043d\u0430"},"masks":["594\\d{9}"]},"GH":{"names":{"en":"Ghana","ru":"\u0413\u0430\u043d\u0430"},"masks":["233\\d{9}"]},"GI":{"names":{"en":"Gibraltar","ru":"\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440"},"masks":["350\\d{8}"]},"GL":{"names":{"en":"Greenland","ru":"\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f"},"masks":["299\\d{6}"]},"GM":{"names":{"en":"Gambia","ru":"\u0413\u0430\u043c\u0431\u0438\u044f"},"masks":["220\\d{7}"]},"GN":{"names":{"en":"Guinea","ru":"\u0413\u0432\u0438\u043d\u0435\u044f"},"masks":["224\\d{8}"]},"GQ":{"names":{"en":"Equatorial Guinea","ru":"\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f"},"masks":["240\\d{9}"]},"GR":{"names":{"en":"Greece","ru":"\u0413\u0440\u0435\u0446\u0438\u044f"},"masks":["30\\d{10}"]},"GT":{"names":{"en":"Guatemala","ru":"\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430"},"masks":["502\\d{8}"]},"GU":{"names":{"en":"Guam","ru":"\u0413\u0443\u0430\u043c"},"masks":["1671\\d{7}"]},"GW":{"names":{"en":"GuineaBissau","ru":"\u0413\u0432\u0438\u043d\u0435\u044f\u0411\u0438\u0441\u0430\u0443"},"masks":["245\\d{7}"]},"GY":{"names":{"en":"Guyana","ru":"\u0413\u0430\u0439\u0430\u043d\u0430"},"masks":["592\\d{7}"]},"HK":{"names":{"en":"Hong Kong","ru":"\u0413\u043e\u043d\u043a\u043e\u043d\u0433"},"masks":["852\\d{8}"]},"HN":{"names":{"en":"Honduras","ru":"\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441"},"masks":["504\\d{8}"]},"HR":{"names":{"en":"Croatia","ru":"\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f"},"masks":["385\\d{8}"]},"HT":{"names":{"en":"Haiti","ru":"\u0413\u0430\u0438\u0442\u0438"},"masks":["509\\d{8}"]},"HU":{"names":{"en":"Hungary","ru":"\u0412\u0435\u043d\u0433\u0440\u0438\u044f"},"masks":["36\\d{9}"]},"ID":{"names":{"en":"Indonesia ","ru":"\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f "},"masks":["628\\d{9}","62\\d{7}","62\\d{8}","62\\d{9}","628\\d{8}","628\\d{10}"]},"IE":{"names":{"en":"Ireland","ru":"\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f"},"masks":["353\\d{9}"]},"IL":{"names":{"en":"Israel ","ru":"\u0418\u0437\u0440\u0430\u0438\u043b\u044c "},"masks":["9725\\d{8}","972\\d{8}"]},"IN":{"names":{"en":"India","ru":"\u0418\u043d\u0434\u0438\u044f"},"masks":["91\\d{10}"]},"IO":{"names":{"en":"Diego Garcia","ru":"\u0414\u0438\u0435\u0433\u043e\u0413\u0430\u0440\u0441\u0438\u044f"},"masks":["246\\d{7}"]},"IQ":{"names":{"en":"Iraq","ru":"\u0418\u0440\u0430\u043a"},"masks":["964\\d{10}"]},"IR":{"names":{"en":"Iran","ru":"\u0418\u0440\u0430\u043d"},"masks":["98\\d{10}"]},"IS":{"names":{"en":"Iceland","ru":"\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f"},"masks":["354\\d{7}"]},"IT":{"names":{"en":"Italy","ru":"\u0418\u0442\u0430\u043b\u0438\u044f"},"masks":["39\\d{10}"]},"JM":{"names":{"en":"Jamaica","ru":"\u042f\u043c\u0430\u0439\u043a\u0430"},"masks":["1876\\d{7}"]},"JO":{"names":{"en":"Jordan","ru":"\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f"},"masks":["962\\d{9}"]},"JP":{"names":{"en":"Japan ","ru":"\u042f\u043f\u043e\u043d\u0438\u044f "},"masks":["81\\d{10}","81\\d{9}"]},"KE":{"names":{"en":"Kenya","ru":"\u041a\u0435\u043d\u0438\u044f"},"masks":["254\\d{9}"]},"KG":{"names":{"en":"Kyrgyzstan","ru":"\u041a\u0438\u0440\u0433\u0438\u0437\u0438\u044f"},"masks":["996\\d{9}"]},"KH":{"names":{"en":"Cambodia","ru":"\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430"},"masks":["855\\d{8}"]},"KI":{"names":{"en":"Kiribati","ru":"\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438"},"masks":["686\\d{5}"]},"KM":{"names":{"en":"Comoros","ru":"\u041a\u043e\u043c\u043e\u0440\u044b"},"masks":["269\\d{7}"]},"KN":{"names":{"en":"Saint Kitts & Nevis","ru":"\u0421\u0435\u043d\u0442\u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441"},"masks":["1869\\d{7}"]},"KP":{"names":{"en":"DPR Korea North ","ru":"\u041a\u043e\u0440\u0435\u0439\u0441\u043a\u0430\u044f \u041d\u0414\u0420 "},"masks":["850191\\d{7}","850\\d{8}","850\\d{10}","850\\d{6}","850\\d{8}","850\\d{17}"]},"KR":{"names":{"en":"Korea South","ru":"\u0420\u0435\u0441\u043f. \u041a\u043e\u0440\u0435\u044f"},"masks":["82\\d{9}"]},"KW":{"names":{"en":"Kuwait","ru":"\u041a\u0443\u0432\u0435\u0439\u0442"},"masks":["965\\d{8}"]},"KY":{"names":{"en":"Cayman Islands","ru":"\u041a\u0430\u0439\u043c\u0430\u043d\u043e\u0432\u044b \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["1345\\d{7}"]},"KZ":{"names":{"en":"Kazakhstan","ru":"\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d"},"masks":["76\\d{9}","77\\d{9}"]},"LA":{"names":{"en":"Laos ","ru":"\u041b\u0430\u043e\u0441 "},"masks":["85620\\d{8}","856\\d{8}"]},"LB":{"names":{"en":"Lebanon ","ru":"\u041b\u0438\u0432\u0430\u043d "},"masks":["961\\d{8}","961\\d{7}"]},"LC":{"names":{"en":"Saint Lucia","ru":"\u0421\u0435\u043d\u0442\u041b\u044e\u0441\u0438\u044f"},"masks":["1758\\d{7}"]},"LI":{"names":{"en":"Liechtenstein","ru":"\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d"},"masks":["423\\d{10}"]},"LK":{"names":{"en":"Sri Lanka","ru":"\u0428\u0440\u0438\u041b\u0430\u043d\u043a\u0430"},"masks":["94\\d{9}"]},"LR":{"names":{"en":"Liberia","ru":"\u041b\u0438\u0431\u0435\u0440\u0438\u044f"},"masks":["231\\d{8}"]},"LS":{"names":{"en":"Lesotho","ru":"\u041b\u0435\u0441\u043e\u0442\u043e"},"masks":["266\\d{8}"]},"LT":{"names":{"en":"Lithuania","ru":"\u041b\u0438\u0442\u0432\u0430"},"masks":["370\\d{8}"]},"LU":{"names":{"en":"Luxembourg","ru":"\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433"},"masks":["352\\d{9}"]},"LV":{"names":{"en":"Latvia","ru":"\u041b\u0430\u0442\u0432\u0438\u044f"},"masks":["371\\d{8}"]},"LY":{"names":{"en":"Libya","ru":"\u041b\u0438\u0432\u0438\u044f"},"masks":["218\\d{8}","21821\\d{7}"]},"MA":{"names":{"en":"Morocco","ru":"\u041c\u0430\u0440\u043e\u043a\u043a\u043e"},"masks":["212\\d{9}"]},"MC":{"names":{"en":"Monaco","ru":"\u041c\u043e\u043d\u0430\u043a\u043e"},"masks":["377\\d{9}","377\\d{8}"]},"MD":{"names":{"en":"Moldova","ru":"\u041c\u043e\u043b\u0434\u043e\u0432\u0430"},"masks":["373\\d{8}"]},"ME":{"names":{"en":"Montenegro","ru":"\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f"},"masks":["382\\d{8}"]},"MG":{"names":{"en":"Madagascar","ru":"\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440"},"masks":["261\\d{9}"]},"MH":{"names":{"en":"Marshall Islands","ru":"\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["692\\d{7}"]},"MK":{"names":{"en":"Republic of Macedonia","ru":"\u0420\u0435\u0441\u043f. \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f"},"masks":["389\\d{8}"]},"ML":{"names":{"en":"Mali","ru":"\u041c\u0430\u043b\u0438"},"masks":["223\\d{8}"]},"MM":{"names":{"en":"Burma Myanmar","ru":"\u0411\u0438\u0440\u043c\u0430 \u041c\u044c\u044f\u043d\u043c\u0430"},"masks":["95\\d{8}","95\\d{7}","95\\d{6}"]},"MN":{"names":{"en":"Mongolia","ru":"\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f"},"masks":["976\\d{8}"]},"MO":{"names":{"en":"Macau","ru":"\u041c\u0430\u043a\u0430\u043e"},"masks":["853\\d{8}"]},"MP":{"names":{"en":"Northern Mariana Islands","ru":"\u0421\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u041c\u0430\u0440\u0438\u0430\u043d\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430 \u0421\u0430\u0439\u043f\u0430\u043d"},"masks":["1670\\d{7}"]},"MQ":{"names":{"en":"Martinique","ru":"\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430"},"masks":["596\\d{9}"]},"MR":{"names":{"en":"Mauritania","ru":"\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f"},"masks":["222\\d{8}"]},"MS":{"names":{"en":"Montserrat","ru":"\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442"},"masks":["1664\\d{7}"]},"MT":{"names":{"en":"Malta","ru":"\u041c\u0430\u043b\u044c\u0442\u0430"},"masks":["356\\d{8}"]},"MU":{"names":{"en":"Mauritius","ru":"\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439"},"masks":["230\\d{7}"]},"MV":{"names":{"en":"Maldives","ru":"\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["960\\d{7}"]},"MW":{"names":{"en":"Malawi","ru":"\u041c\u0430\u043b\u0430\u0432\u0438"},"masks":["2651\\d{6}","265\\d{9}"]},"MX":{"names":{"en":"Mexico","ru":"\u041c\u0435\u043a\u0441\u0438\u043a\u0430"},"masks":["52\\d{10}","52\\d{8}"]},"MY":{"names":{"en":"Malaysia ","ru":"\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f "},"masks":["60\\d{9}","60\\d{9}","60\\d{8}","60\\d{7}"]},"MZ":{"names":{"en":"Mozambique","ru":"\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a"},"masks":["258\\d{8}"]},"NA":{"names":{"en":"Namibia","ru":"\u041d\u0430\u043c\u0438\u0431\u0438\u044f"},"masks":["264\\d{9}"]},"NC":{"names":{"en":"New Caledonia","ru":"\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f"},"masks":["687\\d{6}"]},"NE":{"names":{"en":"Niger","ru":"\u041d\u0438\u0433\u0435\u0440"},"masks":["227\\d{8}"]},"NF":{"names":{"en":"Norfolk Island","ru":"\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u043e\u0441\u0442\u0440\u043e\u0432"},"masks":["6723\\d{5}"]},"NG":{"names":{"en":"Nigeria","ru":"\u041d\u0438\u0433\u0435\u0440\u0438\u044f"},"masks":["234\\d{10}","234\\d{8}","234\\d{7}","234\\d{10}"]},"NI":{"names":{"en":"Nicaragua","ru":"\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430"},"masks":["505\\d{8}"]},"NL":{"names":{"en":"Netherlands","ru":"\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b"},"masks":["31\\d{9}"]},"NO":{"names":{"en":"Norway","ru":"\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f"},"masks":["47\\d{8}"]},"NP":{"names":{"en":"Nepal","ru":"\u041d\u0435\u043f\u0430\u043b"},"masks":["977\\d{8}"]},"NR":{"names":{"en":"Nauru","ru":"\u041d\u0430\u0443\u0440\u0443"},"masks":["674\\d{7}"]},"NU":{"names":{"en":"Niue","ru":"\u041d\u0438\u0443\u044d"},"masks":["683\\d{4}"]},"NZ":{"names":{"en":"New Zealand","ru":"\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f"},"masks":["64\\d{9}","64\\d{8}","64\\d{10}"]},"OM":{"names":{"en":"Oman","ru":"\u041e\u043c\u0430\u043d"},"masks":["968\\d{8}"]},"PA":{"names":{"en":"Panama","ru":"\u041f\u0430\u043d\u0430\u043c\u0430"},"masks":["507\\d{7}"]},"PE":{"names":{"en":"Peru","ru":"\u041f\u0435\u0440\u0443"},"masks":["51\\d{9}"]},"PF":{"names":{"en":"French Polynesia","ru":"\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f \u0422\u0430\u0438\u0442\u0438"},"masks":["689\\d{6}"]},"PG":{"names":{"en":"Papua New Guinea","ru":"\u041f\u0430\u043f\u0443\u0430\u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0438\u043d\u0435\u044f"},"masks":["675\\d{8}"]},"PH":{"names":{"en":"Philippines","ru":"\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u044b"},"masks":["63\\d{10}"]},"PK":{"names":{"en":"Pakistan","ru":"\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d"},"masks":["92\\d{10}"]},"PL":{"names":{"en":"Poland","ru":"\u041f\u043e\u043b\u044c\u0448\u0430"},"masks":["48\\d{9}"]},"PS":{"names":{"en":"Palestine","ru":"\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0430"},"masks":["970\\d{9}"]},"PT":{"names":{"en":"Portugal","ru":"\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f"},"masks":["351\\d{9}"]},"PW":{"names":{"en":"Palau","ru":"\u041f\u0430\u043b\u0430\u0443"},"masks":["680\\d{7}"]},"PY":{"names":{"en":"Paraguay","ru":"\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439"},"masks":["595\\d{9}"]},"QA":{"names":{"en":"Qatar","ru":"\u041a\u0430\u0442\u0430\u0440"},"masks":["974\\d{8}"]},"RE":{"names":{"en":"Reunion","ru":"\u0420\u0435\u044e\u043d\u044c\u043e\u043d"},"masks":["262\\d{9}"]},"RO":{"names":{"en":"Romania","ru":"\u0420\u0443\u043c\u044b\u043d\u0438\u044f"},"masks":["40\\d{9}"]},"RS":{"names":{"en":"Serbia","ru":"\u0421\u0435\u0440\u0431\u0438\u044f"},"masks":["381\\d{9}"]},"RW":{"names":{"en":"Rwanda","ru":"\u0420\u0443\u0430\u043d\u0434\u0430"},"masks":["250\\d{9}"]},"SA":{"names":{"en":"Saudi Arabia ","ru":"\u0421\u0430\u0443\u0434\u043e\u0432\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0438\u044f "},"masks":["9665\\d{8}","966\\d{8}"]},"SB":{"names":{"en":"Solomon Islands ","ru":"\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u043e\u0432\u044b \u041e\u0441\u0442\u0440\u043e\u0432\u0430 "},"masks":["677\\d{7}","677\\d{5}"]},"SC":{"names":{"en":"Seychelles","ru":"\u0421\u0435\u0439\u0448\u0435\u043b\u044b"},"masks":["248\\d{7}"]},"SD":{"names":{"en":"Sudan","ru":"\u0421\u0443\u0434\u0430\u043d"},"masks":["249\\d{9}"]},"SE":{"names":{"en":"Sweden","ru":"\u0428\u0432\u0435\u0446\u0438\u044f"},"masks":["46\\d{9}"]},"SG":{"names":{"en":"Singapore","ru":"\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440"},"masks":["65\\d{8}"]},"SH":{"names":{"en":"Saint Helena","ru":"\u041e\u0441\u0442\u0440\u043e\u0432 \u0421\u0432\u044f\u0442\u043e\u0439 \u0415\u043b\u0435\u043d\u044b"},"masks":["290\\d{4}","290\\d{4}"]},"SI":{"names":{"en":"Slovenia","ru":"\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f"},"masks":["386\\d{8}"]},"SK":{"names":{"en":"Slovakia","ru":"\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f"},"masks":["421\\d{9}"]},"SL":{"names":{"en":"Sierra Leone","ru":"\u0421\u044c\u0435\u0440\u0440\u0430\u041b\u0435\u043e\u043d\u0435"},"masks":["232\\d{8}"]},"SM":{"names":{"en":"San Marino","ru":"\u0421\u0430\u043d\u041c\u0430\u0440\u0438\u043d\u043e"},"masks":["378\\d{10}"]},"SN":{"names":{"en":"Senegal","ru":"\u0421\u0435\u043d\u0435\u0433\u0430\u043b"},"masks":["221\\d{9}"]},"SO":{"names":{"en":"Somalia","ru":"\u0421\u043e\u043c\u0430\u043b\u0438"},"masks":["252\\d{8}","252\\d{7}","252\\d{7}"]},"SR":{"names":{"en":"Suriname ","ru":"\u0421\u0443\u0440\u0438\u043d\u0430\u043c "},"masks":["597\\d{7}","597\\d{6}"]},"SS":{"names":{"en":"South Sudan","ru":"\u042e\u0436\u043d\u044b\u0439 \u0421\u0443\u0434\u0430\u043d"},"masks":["211\\d{9}"]},"ST":{"names":{"en":"Sao Tome and Principe","ru":"\u0421\u0430\u043d\u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438"},"masks":["239\\d{7}"]},"SV":{"names":{"en":"El Salvador","ru":"\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440"},"masks":["503\\d{8}"]},"SX":{"names":{"en":"Sint Maarten","ru":"\u0421\u0438\u043d\u0442\u041c\u0430\u0430\u0440\u0442\u0435\u043d"},"masks":["1721\\d{7}"]},"SY":{"names":{"en":"Syrian Arab Republic","ru":"\u0421\u0438\u0440\u0438\u0439\u0441\u043a\u0430\u044f \u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f \u0440\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430"},"masks":["963\\d{9}"]},"SZ":{"names":{"en":"Swaziland","ru":"\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434"},"masks":["268\\d{8}"]},"TC":{"names":{"en":"Turks & Caicos","ru":"\u0422\u0451\u0440\u043a\u0441 \u0438 \u041a\u0430\u0439\u043a\u043e\u0441"},"masks":["1649\\d{7}"]},"TD":{"names":{"en":"Chad","ru":"\u0427\u0430\u0434"},"masks":["235\\d{8}"]},"TG":{"names":{"en":"Togo","ru":"\u0422\u043e\u0433\u043e"},"masks":["228\\d{8}"]},"TH":{"names":{"en":"Thailand ","ru":"\u0422\u0430\u0438\u043b\u0430\u043d\u0434 "},"masks":["66\\d{9}","66\\d{8}"]},"TJ":{"names":{"en":"Tajikistan","ru":"\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d"},"masks":["992\\d{9}"]},"TK":{"names":{"en":"Tokelau","ru":"\u0422\u043e\u043a\u0435\u043b\u0430\u0443"},"masks":["690\\d{4}"]},"TL":{"names":{"en":"East Timor","ru":"\u0412\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0422\u0438\u043c\u043e\u0440"},"masks":["670\\d{7}","67077\\d{6}","67078\\d{6}"]},"TM":{"names":{"en":"Turkmenistan","ru":"\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d"},"masks":["993\\d{8}"]},"TN":{"names":{"en":"Tunisia","ru":"\u0422\u0443\u043d\u0438\u0441"},"masks":["216\\d{8}"]},"TO":{"names":{"en":"Tonga","ru":"\u0422\u043e\u043d\u0433\u0430"},"masks":["676\\d{5}"]},"TR":{"names":{"en":"Turkey","ru":"\u0422\u0443\u0440\u0446\u0438\u044f"},"masks":["90\\d{10}"]},"TT":{"names":{"en":"Trinidad & Tobago","ru":"\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e"},"masks":["1868\\d{7}"]},"TV":{"names":{"en":"Tuvalu ","ru":"\u0422\u0443\u0432\u0430\u043b\u0443 "},"masks":["68890\\d{4}","6882\\d{4}"]},"TW":{"names":{"en":"Taiwan","ru":"\u0422\u0430\u0439\u0432\u0430\u043d\u044c"},"masks":["886\\d{9}","886\\d{8}"]},"TZ":{"names":{"en":"Tanzania","ru":"\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f"},"masks":["255\\d{9}"]},"UA":{"names":{"en":"Ukraine","ru":"\u0423\u043a\u0440\u0430\u0438\u043d\u0430"},"masks":["380\\d{9}"]},"UG":{"names":{"en":"Uganda","ru":"\u0423\u0433\u0430\u043d\u0434\u0430"},"masks":["256\\d{9}"]},"UK":{"names":{"en":"United Kingdom","ru":"\u0412\u0435\u043b\u0438\u043a\u043e\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f"},"masks":["44\\d{10}"]},"UY":{"names":{"en":"Uruguay","ru":"\u0423\u0440\u0443\u0433\u0432\u0430\u0439"},"masks":["598\\d{8}"]},"UZ":{"names":{"en":"Uzbekistan","ru":"\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d"},"masks":["998\\d{9}"]},"VA":{"names":{"en":"Vatican City","ru":"\u0412\u0430\u0442\u0438\u043a\u0430\u043d"},"masks":["396698\\d{5}"]},"VC":{"names":{"en":"Saint Vincent & the Grenadines","ru":"\u0421\u0435\u043d\u0442\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u044b"},"masks":["1784\\d{7}"]},"VE":{"names":{"en":"Venezuela","ru":"\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430"},"masks":["58\\d{10}"]},"VG":{"names":{"en":"British Virgin Islands","ru":"\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438\u0435 \u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["1284\\d{7}"]},"VI":{"names":{"en":"US Virgin Islands","ru":"\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438\u0435 \u0412\u0438\u0440\u0433\u0438\u043d\u0441\u043a\u0438\u0435 \u043e\u0441\u0442\u0440\u043e\u0432\u0430"},"masks":["1340\\d{7}"]},"VN":{"names":{"en":"Vietnam","ru":"\u0412\u044c\u0435\u0442\u043d\u0430\u043c"},"masks":["84\\d{9}","84\\d{10}"]},"VU":{"names":{"en":"Vanuatu ","ru":"\u0412\u0430\u043d\u0443\u0430\u0442\u0443 "},"masks":["678\\d{7}","678\\d{5}"]},"WF":{"names":{"en":"Wallis and Futuna","ru":"\u0423\u043e\u043b\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430"},"masks":["681\\d{6}"]},"WS":{"names":{"en":"Samoa","ru":"\u0421\u0430\u043c\u043e\u0430"},"masks":["685\\d{6}"]},"YE":{"names":{"en":"Yemen ","ru":"\u0419\u0435\u043c\u0435\u043d "},"masks":["967\\d{9}","967\\d{7}","967\\d{8}"]},"ZA":{"names":{"en":"South Africa","ru":"\u042e\u0436\u043d\u043e\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u0435\u0441\u043f."},"masks":["27\\d{9}"]},"ZM":{"names":{"en":"Zambia","ru":"\u0417\u0430\u043c\u0431\u0438\u044f"},"masks":["260\\d{9}"]},"ZW":{"names":{"en":"Zimbabwe","ru":"\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435"},"masks":["263\\d{7}"]},"RU":{"names":{"en":"Russia","ru":"\u0420\u043e\u0441\u0441\u0438\u044f"},"masks":["7\\d{10}","8\\d{10}"]}};

    var isSubmit = false;

    $('form.main-order-form').submit(function(e) {

        if (isSubmit) return false;

        var btn = $("button, input[type=submit]", $(this));

        let form = $(this),
            phone = $("[name=phone]:visible", form),
            phoneNumber = $.trim(phone.val());


        if(phoneNumber.length>0){

            var phoneClean = phoneNumber.replace(/\D/g,''),
                phoneOther = phoneNumber.replace(/\d|\s|\t|\+|\(|\)|\-|\_/g, '');

            e.preventDefault();

            if( phoneOther.length>0 )
                return alert("Проверьте правильность введенного номера.\nНомер телефона должен начинаться с кода страны");

            if( phoneClean.length<7 )
                return alert("Номер должен содержать минимум 7 цифр");

            if( phoneClean.length>20 )
                return alert("Номер не может содержать больше 20 цифр");

            var codes = (typeof geoPhSuggested !== "undefined" && geoPhSuggested.length > 0) ? geoPhSuggested : Object.keys(geoPhCodes);
            codesLength = codes.length;

            code = false;

            loopMain:
                for (var i = 0; i < codesLength; i++){
                    if(geoPhCodes.hasOwnProperty(codes[i])){
                        var masks = geoPhCodes[codes[i]].masks;
                        for(m in masks){
                            if(masks.hasOwnProperty(m)){
                                var re = new RegExp("^"+masks[m]+"$");
                                if(re.test(phoneClean)){
                                    code = codes[i];
                                    break loopMain;
                                }
                            }
                        }
                    }
                }

            if(code===false)
                return alert("Проверьте правильность введенного номера.\nНомер телефона должен начинаться с кода страны");

            btn.prop("disabled", true);
            isSubmit = true;
            Lib.request('/Order/Create', $(this).serialize(), function(result, data) {
                if (!result && data){
                    isSubmit = false;
                    btn.prop("disabled", false);
                    return alert(data);
                }
                if (data.redirect)
                    return document.location.href = data.redirect;
            });

        }
    });
});